//Program Title: To study and implement basic operations on image , different types of conversions.
//Program Description: This scilab code is used to perform basic operations like Quantisation, Down-sampling, Thresholding, Conversion to grayscale, HSV, YCbCr, negation, complement, etc.

//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit
//Scilab version: 6.0.1 (Tested on 64 bit version)
//Toolbox used: Image Processing and Computer Vision Toolbox (version 2.0)
//Reference book name : Digital Image Processing book (author : Rafael C.Gonzalez and Richard E.Woods)

clear;
clc;
clear all;
close;

img = imread('lena.jpg'); // Reading Image
figure(); xname("Original image");
imshow(img);

// Convert Image to Grayscale
img_gray = rgb2gray(img);
figure(); xname("Gray image");
imshow(img_gray);

// Image quantization
// For image quantization we first perform the integer division followed by integral multiplication
img_128 = img/128;
img_128_2 = img_128 * 128;
figure(); xname("Half quantized image"); imshow(img_128_2);


img_64 = img/64;
img_64_2 = img_64 * 64;
figure(); xname("Quarter quantized image"); imshow(img_64_2);

// Image sampling
// In this we pixelate the image resizing it to small size then again to original size, downsampling by a factor of 8
[m,n]=size(img);
// Code for combining 64 pixels into one, downsampling by a factor of 8
image_64_combine = imresize(img,1/8);
image_64_combine = imresize(image_64_combine, 8);
figure(); xname("Sampling image combining 64 pixels"); imshow(image_64_combine);

//Image thresholding
// For binary thresholding we quantize the gray image in two levels
// this is done by performing integral division on gray image by 128 followed by integral multiplication
img_binthresh = img_gray / 128;
img_binthresh = img_binthresh * 255;
figure(); xname("Binary thresholded image"); imshow(img_binthresh);

//Image Interpolation
[rows, columns] = size(img);
scale = [int(2*rows),int(2*columns)];
img_resize_NEAREST = imresize(img, scale, 'nearest'); figure(); xname("Interpolation using nearest"); imshow(img_resize_NEAREST);

img_resize_LINEAR = imresize(img, scale, 'bilinear'); figure(); xname("Interpolation using linear"); imshow(img_resize_LINEAR);

img_resize_BICUBIC = imresize(img, scale, 'bicubic'); figure(); xname("Interpolation using bicubic"); imshow(img_resize_BICUBIC);

//Conversion from RGB to Grayscale
bw=rgb2gray(img);
figure(); xname("Grayscale image");
imshow(bw);

// Converting rgb to hsv
img_hsv = rgb2hsv(img);
figure(); xname("HSV format");
imshow(img_hsv);

// Converting rgb to YCBCR
img_ycbcr = rgb2ycbcr(img);
figure(); xname("YCBCR format");
imshow(img_ycbcr);

// Image negation
img_negetion = 255 - img_gray;
figure(); xname("Negation");imshow(img_negetion);

img_complement = imcomplement(img);
figure(); xname("imcomplement Negation");imshow(img_complement);

//Data-type conversion
img_int8 = im2int8(img);
img_int16 = im2int16(img);
img_int32 = im2int32(img);
img_uint8 = im2uint8(img);
img_uint16 = im2uint16(img);
img_double = im2double(img);

//Subplot
scf(20);
figure(); xname("ALL images");
var_rows = 3;
var_cols = 3;
subplot(var_rows,var_cols,1), imshow(img);
title('Original image');
subplot(var_rows,var_cols,2), imshow(img_gray);
title('Grayscale Image');
subplot(var_rows,var_cols,3), imshow(img_complement);
title('Complement Image');
subplot(var_rows,var_cols,4), imshow(img_binthresh);
title('Binary Image');
subplot(var_rows,var_cols,5), imshow(image_64_combine);
title('Downsampled image');
subplot(var_rows,var_cols,6), imshow(img_negetion);
title('Negated image');
subplot(var_rows,var_cols,7), imshow(img_hsv);
title('HSV Image');
subplot(var_rows,var_cols,8), imshow(img_ycbcr);
title('YcbCr Image');
subplot(var_rows,var_cols,9), imshow(img_64_2);
title('Quantized Image');


